#include "Editor.h"
#include "Level.h"
#include "Application.h"
#include "Util.h"



Editor::Editor() :
  m_CurTile( Dobbs::TILE_GRASS ),
  m_LevelNr( 1 ),
  m_UnitStartDir( Dobbs::DIR_LEFT ),
  m_LevelNameMode( false ),
  m_pCurEntity( NULL ),
  m_pSelectedEntity( NULL ),
  m_CurEntity( Dobbs::ENTITY_TYPE_PLAYER ),
  m_TileMode( true ),
  m_BGTileMode( 1 ),
  m_MouseReleased( false ),
  m_Level( NULL ),
  m_ExtraDataIndex( 0 )
{

}



void Editor::Init()
{

  m_Level.Load( 1 );
  g_App.EnableCursor();

}



void Editor::Exit()
{

  if ( m_pCurEntity )
  {
    delete m_pCurEntity;
    m_pCurEntity = NULL;
  }
  g_App.EnableCursor( false );

}



void Editor::Update()
{

  if ( g_App.m_Input.KeyPressed( VK_ESCAPE ) ) 
  {
    if ( m_LevelNameMode )
    {
      m_LevelNameMode = false;
    }
    else
    {
      g_App.ChangeGameState( new Menu() );
    }
    return;
  }
  if ( m_LevelNameMode )
  {
    return;
  }
  if ( g_App.m_Input.KeyPressed( 'B' ) ) 
  {
    m_BGTileMode = ( ( m_BGTileMode + 1 ) % 3 );
  }
  if ( g_App.m_Input.KeyPressed( '1' ) ) 
  {
    m_Level.EnableLayer( 0, !m_Level.LayerEnabled( 0 ) );
  }
  if ( g_App.m_Input.KeyPressed( '2' ) ) 
  {
    m_Level.EnableLayer( 1, !m_Level.LayerEnabled( 1 ) );
  }
  if ( g_App.m_Input.KeyPressed( '3' ) ) 
  {
    m_Level.EnableLayer( 2, !m_Level.LayerEnabled( 2 ) );
  }
  if ( g_App.m_Input.KeyPressed( 'L' ) ) 
  {
    // jump to last level
    int   Nr = m_LevelNr;

    while ( true )
    {
      ++Nr;
      FILE*     ioIn = fopen( Util::AppPath( "levels\\level%03d.lev", Nr ), "rb" );
      if ( ioIn != NULL )
      {
        fclose( ioIn );
      }
      else
      {
        break;
      }
    }
    if ( Nr > 0 )
    {
      Nr--;
    }
    ChangeToLevel( Nr );
  }
  if ( g_App.m_Input.KeyPressed( 'D' ) ) 
  {
    m_UnitStartDir = ( ( m_UnitStartDir + 1 ) % 8 );
    delete m_pCurEntity;
    m_pCurEntity = NULL;
    if ( m_CurEntity != Dobbs::ENTITY_TYPE_NONE )
    {
      m_pCurEntity = Entity::SpawnEntity( m_CurEntity, g_App.m_Input.MouseX(), g_App.m_Input.MouseY(), (Dobbs::DirFlags)m_UnitStartDir );
    }
  }

  if ( g_App.m_Input.KeyDown( VK_SHIFT ) )
  {
    if ( g_App.m_Input.KeyPressed( 'W' ) ) 
    {
      // decrease level width
      if ( m_Level.Width() > Dobbs::LEVEL_DEFAULT_WIDTH )
      {
        for ( int i = 0; i < m_Level.Height(); ++i )
        {
          m_Level.DeleteSpawnedEntityAt( m_Level.Width() - 1, i );
        }
        m_Level.Resize( m_Level.Width() - 1, m_Level.Height() );
      }
    }
    if ( g_App.m_Input.KeyPressed( 'H' ) ) 
    {
      // decrease level height
      if ( m_Level.Height() > Dobbs::LEVEL_DEFAULT_HEIGHT )
      {
        for ( int i = 0; i < m_Level.Width(); ++i )
        {
          m_Level.DeleteSpawnedEntityAt( i, m_Level.Height() - 1 );
        }
        m_Level.Resize( m_Level.Width(), m_Level.Height() - 1 );
      }
    }
    if ( ( g_App.m_Input.KeyPressed( VK_ADD ) )
    ||   ( g_App.m_Input.KeyPressed( VK_OEM_PLUS ) ) )
    {
      ++m_LevelNr;

      ChangeToLevel( m_LevelNr );
    }
    else if ( ( g_App.m_Input.KeyPressed( VK_SUBTRACT ) )
    ||        ( g_App.m_Input.KeyPressed( VK_OEM_MINUS ) ) )
    {
      if ( m_LevelNr > 1 )
      {
        --m_LevelNr;

        ChangeToLevel( m_LevelNr );
      }
    }
  }
  else if ( g_App.m_Input.KeyPressed( 'W' ) ) 
  {
    // increase level width
    if ( m_Level.Width() < 1000 )
    {
      m_Level.Resize( m_Level.Width() + 1, m_Level.Height() );
    }
  }
  else if ( g_App.m_Input.KeyPressed( 'H' ) ) 
  {
    // increase level height
    if ( m_Level.Height() < 1000 )
    {
      m_Level.Resize( m_Level.Width(), m_Level.Height() + 1 );
    }
  }
  else if ( ( g_App.m_Input.KeyPressed( VK_ADD ) )
  ||        ( g_App.m_Input.KeyPressed( VK_OEM_PLUS ) ) )
  {
    if ( m_TileMode )
    {
      m_CurTile = (Dobbs::TileType)( ( m_CurTile + 1 ) % Dobbs::TILE_LAST_ENTRY );
    }
    else
    {
      delete m_pCurEntity;
      m_CurEntity = (Dobbs::EntityTypes)( ( m_CurEntity + 1 ) % Dobbs::ENTITY_LAST_ENTRY );
      if ( m_CurEntity == Dobbs::ENTITY_TYPE_NONE )
      {
        m_CurEntity = (Dobbs::EntityTypes)( m_CurEntity + 1 );
      }
      m_pCurEntity = Entity::SpawnEntity( m_CurEntity, 0, 0, Dobbs::DIR_LEFT );
    }
  }
  else if ( ( g_App.m_Input.KeyPressed( VK_SUBTRACT ) )
  ||        ( g_App.m_Input.KeyPressed( VK_OEM_MINUS ) ) )
  {
    if ( m_TileMode )
    {
      m_CurTile = (Dobbs::TileType)( ( m_CurTile + Dobbs::TILE_LAST_ENTRY - 1 ) % Dobbs::TILE_LAST_ENTRY );
    }
    else
    {
      delete m_pCurEntity;
      m_CurEntity = (Dobbs::EntityTypes)( ( m_CurEntity + Dobbs::ENTITY_LAST_ENTRY - 1 ) % Dobbs::ENTITY_LAST_ENTRY );
      if ( m_CurEntity == Dobbs::ENTITY_TYPE_NONE )
      {
        m_CurEntity = (Dobbs::EntityTypes)( Dobbs::ENTITY_LAST_ENTRY - 1 );
      }
      m_pCurEntity = Entity::SpawnEntity( m_CurEntity, 0, 0, Dobbs::DIR_LEFT );
    }
  }

  if ( g_App.m_Input.KeyDown( VK_LEFT ) )
  {
    if ( ( m_pSelectedEntity )
    &&   ( !m_TileMode ) )
    {
      m_pSelectedEntity->SetPosition( m_pSelectedEntity->GetX() - 1, m_pSelectedEntity->GetY() );
    }
    else if ( m_Level.m_OffsetX > 0 )
    {
      m_Level.m_OffsetX -= Dobbs::TILE_WIDTH;
    }
  }
  if ( g_App.m_Input.KeyDown( VK_RIGHT ) )
  {
    if ( ( m_pSelectedEntity )
    &&   ( !m_TileMode ) )
    {
      m_pSelectedEntity->SetPosition( m_pSelectedEntity->GetX() + 1, m_pSelectedEntity->GetY() );
    }
    else if ( m_Level.m_OffsetX < m_Level.Width() * Dobbs::TILE_WIDTH - 800 )
    {
      m_Level.m_OffsetX += Dobbs::TILE_WIDTH;
    }
  }
  if ( g_App.m_Input.KeyDown( VK_UP ) )
  {
    if ( ( m_pSelectedEntity )
    &&   ( !m_TileMode ) )
    {
      m_pSelectedEntity->SetPosition( m_pSelectedEntity->GetX(), m_pSelectedEntity->GetY() - 1 );
    }
    else if ( m_Level.m_OffsetY > 0 )
    {
      m_Level.m_OffsetY -= Dobbs::TILE_HEIGHT;
    }
  }
  if ( g_App.m_Input.KeyDown( VK_DOWN ) )
  {
    if ( ( m_pSelectedEntity )
    &&   ( !m_TileMode ) )
    {
      m_pSelectedEntity->SetPosition( m_pSelectedEntity->GetX(), m_pSelectedEntity->GetY() + 1 );
    }
    else if ( m_Level.m_OffsetY < m_Level.Height() * Dobbs::TILE_HEIGHT - 600 )
    {
      m_Level.m_OffsetY += Dobbs::TILE_HEIGHT;
    }
  }


  if ( g_App.m_Input.MouseButtonDown( 1 ) )
  {
    if ( m_TileMode )
    {
      int   TX = ( m_Level.m_OffsetX + g_App.m_Input.MouseX() ) / 32;
      int   TY = ( m_Level.m_OffsetY + g_App.m_Input.MouseY() ) / 32;

      m_Level.SetTile( m_BGTileMode, TX, TY, m_CurTile );
    }
    else if ( m_MouseReleased )
    {
      m_MouseReleased = false;
      Entity*   pEntityBelow = m_Level.FindEntityAt( m_Level.m_OffsetX + g_App.m_Input.MouseX(), m_Level.m_OffsetY + g_App.m_Input.MouseY() );
      if ( pEntityBelow )
      {
        m_pSelectedEntity = pEntityBelow;
      }
      else if ( m_pCurEntity )
      {
        m_pSelectedEntity = m_Level.SpawnEntity( m_CurEntity, m_UnitStartDir, m_pCurEntity->GetX(), m_pCurEntity->GetY() );
      }
    }
  }
  else
  {
    m_MouseReleased = true;
  }
  if ( g_App.m_Input.MouseButtonDown( 2 ) )
  {
    if ( m_TileMode )
    {
      int   TX = ( m_Level.m_OffsetX + g_App.m_Input.MouseX() ) / 32;
      int   TY = ( m_Level.m_OffsetY + g_App.m_Input.MouseY() ) / 32;

      m_CurTile = m_Level.TileFromLayer( m_BGTileMode, TX, TY );
    }
    else
    {
      Entity*   pEntityBelow = m_Level.FindEntityAt( m_Level.m_OffsetX + g_App.m_Input.MouseX(), m_Level.m_OffsetY + g_App.m_Input.MouseY() );
      if ( pEntityBelow )
      {
        if ( pEntityBelow == m_pSelectedEntity )
        {
          m_pSelectedEntity = NULL;
        }
        m_Level.RemoveEntity( pEntityBelow );
      }
      else
      {
        m_pSelectedEntity = NULL;
      }
    }
  }
  if ( g_App.m_Input.KeyPressed( VK_F2 ) )
  {
    m_Level.Save( m_LevelNr );
  }

}



void Editor::OnMouseUpdate( int Buttons, int X, int Y )
{

}



void Editor::AutoTile()
{

  // automatic rearrangement of tile patterns
  for ( int i = 0; i < m_Level.Width(); ++i )
  {
    for ( int j = 0; j < m_Level.Height(); ++j )
    {
      Dobbs::TileType   Tile = m_Level.TileFromLayer( m_BGTileMode, i, j );

      if ( ( Tile == Dobbs::TILE_PLATINE_NE )
      ||   ( Tile == Dobbs::TILE_PLATINE_NW ) )
      {
        if ( ( i + j ) % 2 )
        {
          m_Level.SetTile( m_BGTileMode, i, j, Dobbs::TILE_PLATINE_NE );
        }
        else
        {
          m_Level.SetTile( m_BGTileMode, i, j, Dobbs::TILE_PLATINE_NW );
        }
      }
      if ( ( i == 11 )
      &&   ( j == 146 ) )
      {
        Tile = Tile;
      }
      if ( m_Level.IsTileBlocking( NULL, m_Level.Tile( i, j - 1 ), Dobbs::TILE_EMPTY, Dobbs::DIR_FALL ) )
      {
        m_Level.FullTile( i, j ).Color = 0xffc0c0c0;
      }
      else
      {
        m_Level.FullTile( i, j ).Color = 0xffffffff;
      }
    }
  }

}



void Editor::OnChar( char Key )
{

  if ( !m_LevelNameMode )
  {
    if ( g_App.m_Input.KeyPressed( 'A' ) )
    {
      AutoTile();
    }
    if ( g_App.m_Input.KeyPressed( 'R' ) )
    {
      // replace
      int   TX = ( m_Level.m_OffsetX + g_App.m_Input.MouseX() ) / 32;
      int   TY = ( m_Level.m_OffsetY + g_App.m_Input.MouseY() ) / 32;

      Dobbs::TileType   TileOld = m_Level.TileFromLayer( m_BGTileMode, TX, TY );

      for ( int i = 0; i < Dobbs::SCREEN_WIDTH / 32; ++i )
      {
        for ( int j = 0; j < Dobbs::SCREEN_HEIGHT / 32; ++j )
        {
          if ( m_Level.TileFromLayer( m_BGTileMode, m_Level.m_OffsetX / 32 + i, m_Level.m_OffsetY / 32 + j ) == TileOld )
          {
            m_Level.SetTile( m_BGTileMode, m_Level.m_OffsetX / 32 + i, m_Level.m_OffsetY / 32 + j, m_CurTile );
          }
        }
      }
    }
    if ( g_App.m_Input.KeyPressed( 'Y' ) )
    {
      if ( m_pSelectedEntity )
      {
        char    Temp[200];
        wsprintfA( Temp, "%d", (int)m_pSelectedEntity->Angle() );
        m_Entry = Temp;
        m_LevelNameMode = true;
        m_ExtraDataIndex = -1;
      }
    }
    if ( g_App.m_Input.KeyPressed( 'N' ) )
    {
      if ( m_pSelectedEntity )
      {
        char    Temp[200];
        wsprintfA( Temp, "%d", m_pSelectedEntity->m_ExtraData );
        m_Entry = Temp;
        m_LevelNameMode = true;
        m_ExtraDataIndex = 0;
      }
    }
    if ( g_App.m_Input.KeyPressed( 'O' ) )
    {
      if ( m_pSelectedEntity )
      {
        char    Temp[200];
        wsprintfA( Temp, "%d", m_pSelectedEntity->m_ExtraData2 );
        m_Entry = Temp;
        m_LevelNameMode = true;
        m_ExtraDataIndex = 1;
      }
    }
    if ( g_App.m_Input.KeyPressed( 'M' ) )
    {
      m_TileMode = !m_TileMode;
      delete m_pCurEntity;
      m_pCurEntity = NULL;
      if ( !m_TileMode )
      {
        if ( m_CurEntity != Dobbs::ENTITY_TYPE_NONE )
        {
          m_pCurEntity = Entity::SpawnEntity( m_CurEntity, g_App.m_Input.MouseX(), g_App.m_Input.MouseY(), (Dobbs::DirFlags)m_UnitStartDir );
        }
      }
    }
    return;
  }
  else if ( m_Level.m_Name.length() < 50 )
  {
    if ( ( (unsigned char)Key ) >= 32 )
    {
      m_Entry += Key;
    }
  }

}




void Editor::OnKeyDown( char Key )
{

  if ( m_LevelNameMode )
  {
    if ( Key == VK_BACK )
    {
      if ( m_Entry.length() )
      {
        m_Entry.resize( m_Entry.length() - 1 );
      }
    }
    else if ( Key == VK_RETURN )
    {
      if ( m_pSelectedEntity )
      {
        if ( m_ExtraDataIndex == 0 )
        {
          m_pSelectedEntity->m_ExtraData = atoi( m_Entry.c_str() );
        }
        else if ( m_ExtraDataIndex == 1 )
        {
          m_pSelectedEntity->m_ExtraData2 = atoi( m_Entry.c_str() );
        }
        else if ( m_ExtraDataIndex == -1 )
        {
          m_pSelectedEntity->SetAngle( (float)atof( m_Entry.c_str() ) );
        }
      }
      m_LevelNameMode = false;
    }
  }

}



void Editor::ChangeToLevel( int Nr )
{

  m_LevelNr = Nr;

  m_Level.Load( m_LevelNr );

  m_pSelectedEntity = NULL;

}



void Editor::Render()
{

  // Render all visible sprites
  g_App.RenderTextureSection( g_App.Section( "Background" ), 0, 0, 0xff808080 );

  m_Level.Render( 0xffffffff );

  if ( m_TileMode )
  {
    g_App.RenderTile( m_CurTile, g_App.m_Input.MouseX(), g_App.m_Input.MouseY() );

    int   TX = ( m_Level.m_OffsetX + g_App.m_Input.MouseX() ) / 32;
    int   TY = ( m_Level.m_OffsetY + g_App.m_Input.MouseY() ) / 32;

    char    Temp[300];
    sprintf( Temp, "Pos: %d,%d (%d) BGMode: %d", TX, TY, TX + TY * m_Level.Width(), m_BGTileMode );
    g_App.RenderText( "GUI.Small", Temp, 250, 582 );
  }
  else if ( m_pCurEntity )
  {
    m_pCurEntity->SetPosition( m_Level.m_OffsetX + g_App.m_Input.MouseX(), m_Level.m_OffsetY + g_App.m_Input.MouseY() );
    m_pCurEntity->Render( m_Level.m_OffsetX, m_Level.m_OffsetY );

    char    Temp[300];
    sprintf( Temp, "Pos: %d,%d", m_Level.m_OffsetX + g_App.m_Input.MouseX(), m_Level.m_OffsetY + g_App.m_Input.MouseY() );
    g_App.RenderText( "GUI.Small", Temp, 250, 582 );
  }
  if ( ( m_pSelectedEntity )
  &&   ( !m_TileMode ) )
  {
    char    Temp[300];
    sprintf( Temp, "Extradata: %d/%d", m_pSelectedEntity->m_ExtraData, m_pSelectedEntity->m_ExtraData2 );
    g_App.RenderText( "GUI.Small", Temp, 370, 582 );
  }

  char    Temp[300];
  sprintf( Temp, "Level: %d, %dx%d", m_LevelNr, m_Level.Width(), m_Level.Height() );
  g_App.RenderText( "GUI.Small", Temp, 5, 582 );

  g_App.RenderText( "GUI.Small", "N to change level name, Left mouse button to set tile, right mouse button to pick tile, L to jump to last level", 5,  5 );
  g_App.RenderText( "GUI.Small", "Plus/Minus to change current tile, D to change a tiles direction, Shift Plus/Minus to change currnet level, F2 to save current level", 5, 20 );
  if ( m_LevelNameMode )
  {
    g_App.RenderText( "GUI.Small", "Entry: " + m_Entry, 5, 30 );
  }

}